/**
* Script: itemset.js
* Written by: Radnen
* Updated: 1/11/2011
**/

function ItemSet(parent, x, y, w, h, iw, ih)
{
	this.inherit = Control;
	this.inherit(parent, x, y, w*iw, h*ih);
	
	this.useWindow = true;
	this.lockWidth = false;
	this.lockHeight = false;
	this.iw = iw;
	this.ih = ih;
	
	this.index = 0;
	this.cur = 0;
	this.items = [];
	
	this.onItemDoubleClick = function() {};
	
	this.__defineGetter__("item", function() {
		if (this.items[this.cur] != null) return this.items[this.cur];
		else return null;
	})
	
	this.__defineGetter__("over", function() {
		if (this.items[this.index] != null) return this.items[this.index];
		else return null;
	})
	
	this.onSelect = function(){}
	
	this.update = function() {
		this.updateMouse();
	}
		
	this.draw = function() {
		this.x = this.parent.x + this.xx;
		this.y = this.parent.y + this.yy;
		if (this.lockWidth) this.w = this.parent.w - this.ww;
		if (this.lockHeight) this.h = this.parent.h - this.hh;
		if (this.useWindow) System.itemWindow.drawWindow(this.x, this.y, this.w, this.h);
				
		var i = 0;
		for (var y = 0; y < this.h; y += this.ih) {
			for (var x = 0; x < this.w; x += this.iw) {
				if (this.items[i] != undefined) {
					if (i == this.cur) {
						System.highlight.drawWindow(this.x+x+3, this.y+y+3, this.iw-6, this.ih-6);
					}
					
					var img = Resources.images[Items[this.items[i]].image];
					if (Genesis.player.canEquip(this.items[i]))
						img.blit(this.x+x+(this.iw/2-img.width/2), this.y+y+(this.ih/2-img.height/2));
					else Resources.images[Items[this.items[i]].image].blitMask(this.x+x, this.y+y, Colors.red);
				}
				if (Cursor.isWithin(this.x+x, this.y+y, this.iw, this.ih)) {
					this.index = i;
					if (this.focused) {
						if (Cursor.onLeftHold() || Cursor.onRightHold()) { this.cur = i; this.onSelect(); }
						if (Cursor.onLeftDoubleClick()) this.onItemDoubleClick();
					}
				}
				i++;
			}
		}
		
		if (this.focused && Cursor.isWithin(this.x, this.y, this.w, this.h) && this.over != null) {
			DrawBorderedText(Cursor.x+20, Cursor.y-20, Items[this.over].name);
		}
	}
}